/*
 * inc_wdt.h
 *
 * Definitions for Inter Node Communication - inc wdt
 *
 *   Copyright (C) 2015 Jiada Wang <jiada_wang@mentor.com>
 *   Copyright (C) 2015 Mentor Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of the copyright holders not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no representations
 * about the suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifndef INC_WDT__H
#define INC_WDT__H

#define INC_WDT_RECEIVE_BUFFER_LEN		1
#define INC_WDT_DGRAM_RECV_TIMEOUT_S		2
#define MAX_PING_COUNT_PATH_LENGTH		100
#define MAX_ADDR_STRING_LENGTH			20
#define INC_WDT_DGRAM_MAX			INC_WDT_RECEIVE_BUFFER_LEN
#define INC_WDT_MSGID_WDGS_WDG_C_WATCHDOG	0x62
#define INC_WDT_MSGID_WDG_WDGS_R_WATCHDOG	0x63

#define PORT_OFFSET				0xC700
#define WDG_PORT				(0x09 | PORT_OFFSET)

#define DEFAULT_TIMEVAL_USEC			1000000
#define DEFAULT_LOCAL_ADDR			"192.168.203.1"
#define DEFAULT_REMOTE_ADDR			"192.168.203.2"
#define DEFAULT_SYSFS_PATH			"/sys/devices/soc0/soc.0/2000000.aips-bus/20bc000.wdog/watchdog/watchdog0/ping_count"

struct inc_wdt_data {
	int sockfd;
	struct timespec timer;
	struct timespec timer_retry;
	int ping_count;
	struct sk_dgram *dgram;
	char recv_buffer[INC_WDT_RECEIVE_BUFFER_LEN];
	bool response_received;
	bool command_prevented;
	bool notify_sd;
	pthread_t rx_task;
	pthread_mutex_t lock;
};

#endif
